<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCarsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cars', function (Blueprint $table) {
            $table->increments('id');
            $table->string('model');
            $table->unsignedInteger('brand_id');
            $table->string('kmeter');
            $table->string('price');
            $table->string('image', 500);
            $table->string('year');
            $table->string('engine');
            $table->boolean('used')->default(false);
            $table->boolean('featured')->default(false);
            $table->boolean('sold')->default(false);
            $table->string('text', 500)->default('informacije o autu');
            $table->timestamps();

            $table->foreign('brand_id')->references('id')->on('brands');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cars');
    }
}
